unit  CM100;          { cm100.dll interface unit }

interface
{type PSingle=^Single;
type PWord=^Word;}
type DWORD=Cardinal;    

//====================
//Error Code Definitions
const
 CM100_NoError                 =   0;
 CM100_DriverError             =   1;
 CM100_ActiveBoardError        =   2;
 CM100_BoardNumberError        =   3;
 CM100_PortNumberError         =   4;
 CM100_InitError               =   7;

 CM100_SoftBufferIsEmpty       =   21;
 CM100_SoftBufferIsFull        =   22;
 CM100_TimeOut                 =   23;
 CM100_SetCyclicMsgFailure     =   24;
 CM100_DpramOverRange          =   25;
 CM100_NoDpramCmd              =   26;
 CM100_ModeError               =   27;
 CM100_NoFileInside            =   30;
 CM100_DownloadFailure         =   31;
 CM100_EEPROMDamage            =   32;
 CM100_NotEnoughSpace          =   33;
 CM100_StillDownloading        =   34;
 CM100_BoardModeError          =   35;
 CM100_SetDateTimeFailure      =   36;

type
    ConfigStruct = record
    AccCode : array[0..3] of BYTE;
    AccMask : array[0..3] of BYTE;
    BaudRate: BYTE;
    BT0: BYTE;
    BT1: BYTE;
End;
//BaudRate 0:user define 1=10K   2=20K   3=50K  4=125K  5=250K  6=500K 7=800K  8=1Mbps

type
   PacketStruct = record
   MsgTimeStamps:Int64;
   mode: BYTE;
   id: DWORD;
   rtr: BYTE;
   len: BYTE;
   data: array[0..7] of BYTE;
End;
//mode 0 -> 11 bits ID    1 -> 29 bits ID 

function CM100_GetDllVersion:WORD; StdCall;
function CM100_GetBoardInf(BoardNo:BYTE; Var dwVID:LongInt; Var dwDID:LongInt;Var dwSVID:LongInt;Var dwSDID:LongInt;Var dwSAuxID:LongInt;Var dwIrq:LongInt):Integer; StdCall;
function CM100_TotalBoard:Integer; StdCall;
function CM100_TotalCM100Board:Integer; StdCall;
function CM100_TotalDNM100Board:Integer; StdCall;
function CM100_TotalCPM100Board:Integer; StdCall;
function CM100_GetCM100BoardSwitchNo(BoardCntNo:BYTE; var BoardSwitchNo:BYTE):Integer; StdCall;
function CM100_GetDNM100BoardSwitchNo(BoardCntNo:BYTE; var BoardSwitchNo:BYTE):Integer; StdCall;
function CM100_GetCPM100BoardSwitchNo(BoardCntNo:BYTE; var BoardSwitchNo:BYTE):Integer; StdCall;
function CM100_GetCardPortNum(BoardNo:BYTE; var bGetPortNum:BYTE):Integer; StdCall;

function CM100_ActiveBoard(BoardNo:BYTE):Integer; StdCall;
function CM100_CloseBoard(BoardNo:BYTE):Integer; StdCall;
function CM100_BoardIsActive(BoardNo:BYTE):Integer; StdCall;

function CM100_AdjustDateTime(BoardNo:BYTE):Integer; StdCall;
function CM100_Reset(BoardNo:BYTE; Port:BYTE):Integer; StdCall;
function CM100_Init(BoardNo:BYTE; Port:BYTE):Integer; StdCall;
function CM100_HardwareReset(BoardNo:BYTE; Port:BYTE):Integer; StdCall;
function CM100_Check186Mode(BoardNo:BYTE; var Mode:BYTE):Integer; StdCall;
function CM100_Status(BoardNo:BYTE; Port:BYTE; var bStatus:BYTE):Integer; StdCall;

function CM100_AddCyclicTxMsg(BoardNo:BYTE; Port:BYTE; Mode:BYTE; MsgID:DWORD; RTR:BYTE; DataLen:BYTE; var Data:BYTE; TimPeriod:DWORD; Transmits:DWORD; var Handle:BYTE):Integer; StdCall;
function CM100_DeleteCyclicTxMsg(BoardNo:BYTE; Port:BYTE; Handle:BYTE):Integer; StdCall;
function CM100_EnableCyclicTxMsg(BoardNo:BYTE; Port:BYTE; Handle:BYTE):Integer; StdCall;
function CM100_DisableCyclicTxMsg(BoardNo:BYTE; Port:BYTE; Handle:BYTE):Integer; StdCall;
function CM100_CheckCyclicTxRestMsg(BoardNo:BYTE; Port:BYTE; Handle:BYTE, var RestCount:DWORD):Integer; StdCall;

function CM100_OutputByte(BoardNo:BYTE; Port:BYTE; wOffset:WORD; bValue:BYTE):Integer; StdCall;
function CM100_InputByte(BoardNo:BYTE; Port:BYTE; wOffset:WORD; var bValue:BYTE):Integer; StdCall;

function CM100_IsTxTimeout(BoardNo:BYTE; Port:BYTE; var Status:BYTE):Integer; StdCall;
function CM100_SetSystemMsg(BoardNo:BYTE; Port:BYTE; Mode:BYTE):Integer; StdCall;

////////////////////////////////////////////////////////////////
//                                                            //
//  Parameters and Functions Only For CM100 default Firmware  //
//                                                            //
////////////////////////////////////////////////////////////////
function CM100_ClearSoftBuffer(BoardNo:BYTE; Port:BYTE):Integer; StdCall;
function CM100_ClearBufferStatus(BoardNo:BYTE; Port:BYTE):Integer; StdCall;
function CM100_ClearTxSoftBuffer(BoardNo:BYTE; Port:BYTE):Integer; StdCall;
function CM100_ClearRxSoftBuffer(BoardNo:BYTE; Port:BYTE):Integer; StdCall;
function CM100_ClearDataOverrun(BoardNo:BYTE; Port:BYTE):Integer; StdCall;

function CM100_Config(BoardNo:BYTE; Port:BYTE; Var CanConfig:ConfigStruct):Integer; Stdcall;
function CM100_ConfigWithoutStruct(BoardNo:BYTE; Port:BYTE; AccCode:DWORD; AccMask:DWORD; BaudRate:BYTE; BT0:BYTE; BT1:BYTE):Integer; Stdcall;

function CM100_RxMsgCount(BoardNo:BYTE; Port:BYTE):Integer; Stdcall;
function CM100_ReceiveMsg(BoardNo:BYTE; Port:BYTE; Var CanPacket:PacketStruct):Integer; Stdcall;
function CM100_ReceiveMultiMsg(BoardNo:BYTE; Port:BYTE; Cnt:DWORD; Timeout:WORD; Var CanPacket:PacketStruct):DWORD; Stdcall;
function CM100_ReceiveWithoutStruct(BoardNo:BYTE; Port:BYTE; Var Mode:BYTE; Var MsgID:DWORD; Var RTR:BYTE; Var DataLen:BYTE; Var Data:BYTE; Var UpperTime:DWORD; Var LowerTime:DWORD):Integer; Stdcall;
function CM100_ReceiveMultiMsgWithoutStruct(BoardNo:BYTE; Port:BYTE; Cnt:DWORD; Timeout:WORD; Var Mode:BYTE; Var MsgID:DWORD; Var RTR:BYTE; Var DataLen:BYTE; Var Data:BYTE; Var UpperTime:DWORD; Var LowerTime:DWORD):DWORD; Stdcall;
                    
function CM100_SendMsg(BoardNo:BYTE; Port:BYTE; Var CanPacket: PacketStruct):Integer; Stdcall;
function CM100_SendWithoutStruct(BoardNo:BYTE; Port:BYTE; Mode:BYTE; MsgID:DWORD; RTR:BYTE; DataLen:BYTE; Var Data:BYTE):Integer; Stdcall;

///////////////////////////////////////////////////////////////
//                                                           //
//  Parameters and Functions Only For user-defined Firmware  //
//                                                           //
///////////////////////////////////////////////////////////////

//Interrupt To User ISR
const
 CAN_COMM_CMD_FROM_CM100  = $d1;

//API Definitions
function CM100_SJA1000Config(BoardNo:BYTE; Port:BYTE; AccCode:DWORD; AccMask:DWORD; BaudRate:BYTE; BT0:BYTE; BT1:BYTE):Integer; Stdcall;
function CM100_EnableSJA1000(BoardNo:BYTE; Port:BYTE):Integer; Stdcall;
function CM100_DisableSJA1000(BoardNo:BYTE; Port:BYTE):Integer; Stdcall;
function CM100_DPRAMInttToCM100(BoardNo:BYTE; Port:BYTE; Data:BYTE):Integer; Stdcall;
function CM100_DPRAMWriteByte(BoardNo:BYTE; Port:BYTE; Address:WORD; Data:BYTE):Integer; Stdcall;
function CM100_DPRAMWriteWord(BoardNo:BYTE; Port:BYTE; Address:WORD; Data:WORD):Integer; Stdcall;
function CM100_DPRAMWriteDword(BoardNo:BYTE; Port:BYTE; Address:WORD; Data:DWORD):Integer; Stdcall;
function CM100_DPRAMWriteMultiByte(BoardNo:BYTE; Port:BYTE; Address:WORD; var Data:BYTE; DataNum:WORD):Integer; Stdcall;
function CM100_DPRAMReadByte(BoardNo:BYTE; Port:BYTE; Address:WORD; var Data:BYTE):Integer; Stdcall;
function CM100_DPRAMReadWord(BoardNo:BYTE; Port:BYTE; Address:WORD; var Data:WORD):Integer; Stdcall;
function CM100_DPRAMReadDword(BoardNo:BYTE; Port:BYTE; Address:WORD; var Data:DWORD):Integer; Stdcall;
function CM100_DPRAMReadMultiByte(BoardNo:BYTE; Port:BYTE; Address:WORD; var Data:BYTE; DataNum:WORD):Integer; Stdcall;
function CM100_DPRAMMemset(BoardNo:BYTE; Port:BYTE; Address:WORD; Data:BYTE; DataNum:WORD):Integer; Stdcall;
function CM100_ReceiveCmd(BoardNo:BYTE; Port:BYTE; var Data:BYTE; var DataNum:WORD):Integer; Stdcall;
function CM100_SendCmd(BoardNo:BYTE; Port:BYTE; var Data:BYTE; DataNum:WORD):Integer; Stdcall;
function CM100_ClearReceiveCmd(BoardNo:BYTE; Port:BYTE):Integer; Stdcall;

//procedure UserIsr(BoardNo_ISR:BYTE; InttValue:BYTE);

function CM100_InstallUserISR(BoardNo:BYTE; Var UserIsr):Integer; Stdcall;
function CM100_RemoveUserISR(BoardNo:BYTE):Integer; Stdcall;
function CM100_ReadUserInttType(BoardNo:BYTE; Var InttType:BYTE):Integer; Stdcall;
function CM100_RunUserProgram(BoardNo:BYTE; Port:BYTE):Integer; Stdcall;
function CM100_EndUserProgram(BoardNo:BYTE; Port:BYTE):Integer; Stdcall;

implementation

function CM100_GetDllVersion;
         external 'CM100.DLL' name 'CM100_GetDllVersion';
function CM100_GetBoardInf;
         external 'CM100.DLL' name 'CM100_GetBoardInf';
function CM100_TotalBoard;
         external 'CM100.DLL' name 'CM100_TotalBoard';
function CM100_TotalCM100Board;
         external 'CM100.DLL' name 'CM100_TotalCM100Board';
function CM100_TotalDNM100Board;
         external 'CM100.DLL' name 'CM100_TotalDNM100Board';
function CM100_TotalCPM100Board;
         external 'CM100.DLL' name 'CM100_TotalCPM100Board';
function CM100_GetCM100BoardSwitchNo;
         external 'CM100.DLL' name 'CM100_GetCM100BoardSwitchNo';
function CM100_GetDNM100BoardSwitchNo;
         external 'CM100.DLL' name 'CM100_GetDNM100BoardSwitchNo';
function CM100_GetCPM100BoardSwitchNo;
         external 'CM100.DLL' name 'CM100_GetCPM100BoardSwitchNo';
function CM100_GetCardPortNum;
         external 'CM100.DLL' name 'CM100_GetCardPortNum';

function CM100_ActiveBoard;
         external 'CM100.DLL' name 'CM100_ActiveBoard';
function CM100_CloseBoard;
         external 'CM100.DLL' name 'CM100_CloseBoard';
function CM100_BoardIsActive;
         external 'CM100.DLL' name 'CM100_BoardIsActive';

function CM100_AdjustDateTime;
         external 'CM100.DLL' name 'CM100_AdjustDateTime';

function CM100_Reset;
         external 'CM100.DLL' name 'CM100_Reset';
function CM100_Init;
         external 'CM100.DLL' name 'CM100_Init';
function CM100_HardwareReset;
         external 'CM100.DLL' name 'CM100_HardwareReset';
function CM100_Check186Mode;
         external 'CM100.DLL' name 'CM100_Check186Mode';
function CM100_Status;
         external 'CM100.DLL' name 'CM100_Status';

function CM100_AddCyclicTxMsg;
         external 'CM100.DLL' name 'CM100_AddCyclicTxMsg';
function CM100_DeleteCyclicTxMsg;
         external 'CM100.DLL' name 'CM100_DeleteCyclicTxMsg';
function CM100_EnableCyclicTxMsg;
         external 'CM100.DLL' name 'CM100_EnableCyclicTxMsg';
function CM100_DisableCyclicTxMsg;
         external 'CM100.DLL' name 'CM100_DisableCyclicTxMsg';
function CM100_CheckCyclicTxRestMsg;
         external 'CM100.DLL' name 'CM100_CheckCyclicTxRestMsg';
         
function CM100_OutputByte;
         external 'CM100.DLL' name 'CM100_OutputByte';
function CM100_InputByte;
         external 'CM100.DLL' name 'CM100_InputByte';

function CM100_IsTxTimeout;
         external 'CM100.DLL' name 'CM100_IsTxTimeout';
function CM100_SetSystemMsg;
         external 'CM100.DLL' name 'CM100_SetSystemMsg';


function CM100_ClearSoftBuffer;
         external 'CM100.DLL' name 'CM100_ClearSoftBuffer';
function CM100_ClearBufferStatus;
         external 'CM100.DLL' name 'CM100_ClearBufferStatus';
function CM100_ClearTxSoftBuffer;
         external 'CM100.DLL' name 'CM100_ClearTxSoftBuffer';
function CM100_ClearRxSoftBuffer;
         external 'CM100.DLL' name 'CM100_ClearRxSoftBuffer';
function CM100_ClearDataOverrun;
         external 'CM100.DLL' name 'CM100_ClearDataOverrun';
function CM100_Config;
         external 'CM100.DLL' name 'CM100_Config';
function CM100_ConfigWithoutStruct;
         external 'CM100.DLL' name 'CM100_ConfigWithoutStruct';
function CM100_RxMsgCount;
         external 'CM100.DLL' name 'CM100_RxMsgCount';
function CM100_ReceiveMsg;
         external 'CM100.DLL' name 'CM100_ReceiveMsg';
function CM100_ReceiveMultiMsg;
         external 'CM100.DLL' name 'CM100_ReceiveMultiMsg';
function CM100_ReceiveWithoutStruct;
         external 'CM100.DLL' name 'CM100_ReceiveWithoutStruct';
function CM100_ReceiveMultiMsgWithoutStruct;
         external 'CM100.DLL' name 'CM100_ReceiveMultiMsgWithoutStruct';
         
function CM100_SendMsg;
         external 'CM100.DLL' name 'CM100_SendMsg';
function CM100_SendWithoutStruct;
         external 'CM100.DLL' name 'CM100_SendWithoutStruct';


function CM100_SJA1000Config;
         external 'CM100.DLL' name 'CM100_SJA1000Config';
function CM100_EnableSJA1000;
         external 'CM100.DLL' name 'CM100_EnableSJA1000';
function CM100_DisableSJA1000;
         external 'CM100.DLL' name 'CM100_DisableSJA1000';
function CM100_DPRAMInttToCM100;
         external 'CM100.DLL' name 'CM100_DPRAMInttToCM100';

function CM100_DPRAMWriteByte;
         external 'CM100.DLL' name 'CM100_DPRAMWriteByte';
function CM100_DPRAMWriteWord;
         external 'CM100.DLL' name 'CM100_DPRAMWriteWord';
function CM100_DPRAMWriteDword;
         external 'CM100.DLL' name 'CM100_DPRAMWriteDword';
function CM100_DPRAMWriteMultiByte;
         external 'CM100.DLL' name 'CM100_DPRAMWriteMultiByte';

function CM100_DPRAMReadByte;
         external 'CM100.DLL' name 'CM100_DPRAMReadByte';
function CM100_DPRAMReadWord;
         external 'CM100.DLL' name 'CM100_DPRAMReadWord';
function CM100_DPRAMReadDword;
         external 'CM100.DLL' name 'CM100_DPRAMReadDword';
function CM100_DPRAMReadMultiByte;
         external 'CM100.DLL' name 'CM100_DPRAMReadMultiByte';

function CM100_DPRAMMemset;
         external 'CM100.DLL' name 'CM100_DPRAMMemset';
function CM100_ReceiveCmd;
         external 'CM100.DLL' name 'CM100_ReceiveCmd';
function CM100_SendCmd;
         external 'CM100.DLL' name 'CM100_SendCmd';
function CM100_ClearReceiveCmd;
         external 'CM100.DLL' name 'CM100_ClearReceiveCmd';
function CM100_InstallUserISR;
         external 'CM100.DLL' name 'CM100_InstallUserISR';
function CM100_RemoveUserISR;
         external 'CM100.DLL' name 'CM100_RemoveUserISR';
function CM100_ReadUserInttType;
         external 'CM100.DLL' name 'CM100_ReadUserInttType';
function CM100_RunUserProgram;
         external 'CM100.DLL' name 'CM100_RunUserProgram';
function CM100_EndUserProgram;
         external 'CM100.DLL' name 'CM100_EndUserProgram';         
end.


