Attribute VB_Name = "CM100_BAS"
Option Explicit
'--------------------------------------------------
' Return Code
'--------------------------------------------------
'CM100_NoError                  0
'CM100_DriverError              1
'CM100_ActiveBoardError         2
'CM100_BoardNumberError         3
'CM100_PortNumberError          4
'CM100_InitError                7
'CM100_SoftBufferIsEmpty       21
'CM100_SoftBufferIsFull        22
'CM100_TimeOut                 23
'CM100_SetCyclicMsgFailure     24
'CM100_DpramOverRange          25
'CM100_NoDpramCmd              26
'CM100_ModeError               27
'CM100_NoFileInside            30
'CM100_DownloadFailure         31
'CM100_EEPROMDamage            32
'CM100_NotEnoughSpace          33
'CM100_StillDownloading        34
'CM100_BoardModeError          35
'CM100_CardTypeError           36

'--------------------------------------------------
' Structure Definitions
'--------------------------------------------------
Public Type ConfigStruct
 AccCode(3) As Byte
 AccMask(3) As Byte
 BaudRate As Byte        'BaudRate 0:user define 1=10K   2=20K   3=50K  4=125K  5=250K  6=500K 7=800K  8=1Mbps
 BT0 As Byte
 BT1 As Byte
End Type

Public Type LongLong
 LowLong As Long
 HighLong As Long
End Type

Public Type PacketStruct
 MsgTimeStamps As LongLong
 Mode As Byte              'mode 0 -> 11 bits ID    1 -> 29 bits ID
 Id As Long
 RTR As Byte
 Dlen As Byte
 Data(7) As Byte
End Type

'--------------------------------------------------
' Common functions
'--------------------------------------------------
Declare Function CM100_GetDllVersion Lib "cm100.dll" () As Integer
Declare Function CM100_GetBoardInf Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, dwVID As Double, dwDID As Double, dwSVID As Double, dwSDID As Double, _
                  dwSAuxID As Double, dwIrqNo As Double) As Integer
Declare Function CM100_TotalBoard Lib "cm100.dll" () As Integer
Declare Function CM100_TotalCM100Board Lib "cm100.dll" () As Integer
Declare Function CM100_TotalDNM100Board Lib "cm100.dll" () As Integer
Declare Function CM100_TotalCPM100Board Lib "cm100.dll" () As Integer
Declare Function CM100_GetCM100BoardSwitchNo Lib "cm100.dll" (ByVal BoardNo As Byte, BoardSwitchNo As Byte) As Integer
Declare Function CM100_GetDNM100BoardSwitchNo Lib "cm100.dll" (ByVal BoardNo As Byte, BoardSwitchNo As Byte) As Integer
Declare Function CM100_GetCPM100BoardSwitchNo Lib "cm100.dll" (ByVal BoardNo As Byte, BoardSwitchNo As Byte) As Integer
Declare Function CM100_GetCardPortNum Lib "cm100.dll" (ByVal BoardNo As Byte, bGetPortNum As Byte) As Integer
Declare Function CM100_ActiveBoard Lib "cm100.dll" (ByVal BoardNo As Byte) As Integer
Declare Function CM100_CloseBoard Lib "cm100.dll" (ByVal BoardNo As Byte) As Integer
Declare Function CM100_BoardIsActive Lib "cm100.dll" (ByVal BoardNo As Byte) As Integer
Declare Function CM100_AdjustDateTime Lib "cm100.dll" (ByVal BoardNo As Byte) As Integer
Declare Function CM100_Reset Lib "cm100.dll" (ByVal BoardNo As Byte, ByVal Port As Byte) As Integer
Declare Function CM100_Init Lib "cm100.dll" (ByVal BoardNo As Byte, ByVal Port As Byte) As Integer
Declare Function CM100_HardwareReset Lib "cm100.dll" (ByVal BoardNo As Byte, ByVal Port As Byte) As Integer
Declare Function CM100_Check186Mode Lib "cm100.dll" (ByVal BoardNo As Byte, Mode As Byte) As Integer
Declare Function CM100_Status Lib "cm100.dll" (ByVal BoardNo As Byte, ByVal Port As Byte, bStatus As Byte) As Integer
Declare Function CM100_AddCyclicTxMsg Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal Mode As Byte, ByVal MsgID As Long, ByVal RTR As Byte, _
                  ByVal DataLen As Byte, Data As Byte, ByVal TimePeriod As Long, ByVal TransmitTimes As Long, Handle As Byte) As Integer
Declare Function CM100_DeleteCyclicTxMsg Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal Handle As Byte) As Integer
Declare Function CM100_EnableCyclicTxMsg Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal Handle As Byte) As Integer
Declare Function CM100_DisableCyclicTxMsg Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal Handle As Byte) As Integer
Declare Function CM100_CheckCyclicTxRestMsg Lib "cm100.dll" (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal Handle As Byte, RestCount As Long) As Integer

Declare Function CM100_OutputByte Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal wOffset As Integer, ByVal bValue As Byte) As Integer
Declare Function CM100_InputByte Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal wOffset As Integer, bValue As Byte) As Integer

Declare Function CM100_IsTxTimeout Lib "cm100.dll" (ByVal BoardNo As Byte, ByVal Port As Byte, bStatus As Byte) As Integer
Declare Function CM100_SetSystemMsg Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal Mode As Byte) As Byte
'--------------------------------------------------
' Functions only for default firmware
'--------------------------------------------------
Declare Function CM100_ClearSoftBuffer Lib "cm100.dll" (ByVal BoardNo As Byte, ByVal Port As Byte) As Integer
Declare Function CM100_ClearBufferStatus Lib "cm100.dll" (ByVal BoardNo As Byte, ByVal Port As Byte) As Integer
Declare Function CM100_ClearTxSoftBuffer Lib "cm100.dll" (ByVal BoardNo As Byte, ByVal Port As Byte) As Integer
Declare Function CM100_ClearRxSoftBuffer Lib "cm100.dll" (ByVal BoardNo As Byte, ByVal Port As Byte) As Integer
Declare Function CM100_ClearDataOverrun Lib "cm100.dll" (ByVal BoardNo As Byte, ByVal Port As Byte) As Integer
Declare Function CM100_Config Lib "cm100.dll" (ByVal BoardNo As Byte, ByVal Port As Byte, CanConfig As ConfigStruct) As Integer
Declare Function CM100_ConfigWithoutStruct Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal AccCode As Long, ByVal AccMask As Long, _
                  ByVal BaudRate As Byte, ByVal BT0 As Byte, ByVal BT1 As Byte) As Integer
Declare Function CM100_RxMsgCount Lib "cm100.dll" (ByVal BoardNo As Byte, ByVal Port As Byte) As Integer
Declare Function CM100_ReceiveMsg Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, CanPacket As PacketStruct) As Integer
Declare Function CM100_ReceiveMultiMsg Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal Cnt As Long, _
                  ByVal Timeout As Integer, CanPacket As PacketStruct) As Long
Declare Function CM100_ReceiveWithoutStruct Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, Mode As Byte, MsgID As Long, RTR As Byte, DataLen As Byte, _
                  Data As Byte, UpperTime As Long, LowerTime As Long) As Integer
Declare Function CM100_ReceiveMultiMsgWithoutStruct Lib "cm100.dll" _
                (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal Cnt As Long, _
                 ByVal Timeout As Integer, Mode As Byte, MsgID As Long, RTR As Byte, _
                 DataLen As Byte, Data As Byte, UpperTime As Long, LowerTime As Long) As Long
Declare Function CM100_SendMsg Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, CanPacket As PacketStruct) As Integer
Declare Function CM100_SendWithoutStruct Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal Mode As Byte, ByVal MsgID As Long, ByVal RTR As Byte, _
                  ByVal DataLen As Byte, Data As Byte) As Integer

'--------------------------------------------------
' Functions only for user-defined firmware
'--------------------------------------------------
'Interrupt To User ISR
Const CAN_COMM_CMD_FROM_CM100 = &HD1

Declare Function CM100_SJA1000Config Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal AccCode As Long, ByVal AccMask As Long, _
                  ByVal BaudRate As Byte, ByVal BT0 As Byte, ByVal BT1 As Byte) As Integer
Declare Function CM100_EnableSJA1000 Lib "cm100.dll" (ByVal BoardNo As Byte, ByVal Port As Byte) As Integer

Declare Function CM100_DisableSJA1000 Lib "cm100.dll" (ByVal BoardNo As Byte, ByVal Port As Byte) As Integer

Declare Function CM100_DPRAMInttToCM100 Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal Data As Byte) As Integer
Declare Function CM100_DPRAMWriteByte Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal Address As Integer, ByVal Data As Byte) As Integer
Declare Function CM100_DPRAMWriteWord Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal Address As Integer, ByVal Data As Integer) As Integer
Declare Function CM100_DPRAMWriteDword Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal Address As Integer, ByVal Data As Long) As Integer
Declare Function CM100_DPRAMWriteMultiByte Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal Address As Integer, Data As Byte, _
                  ByVal DataNum As Integer) As Integer
Declare Function CM100_DPRAMReadByte Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal Address As Integer, Data As Byte) As Integer
Declare Function CM100_DPRAMReadWord Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal Address As Integer, Data As Integer) As Integer
Declare Function CM100_DPRAMReadDword Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal Address As Integer, Data As Long) As Integer
Declare Function CM100_DPRAMReadMultiByte Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal Address As Integer, Data As Byte, _
                  ByVal DataNum As Integer) As Integer
Declare Function CM100_DPRAMMemset Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, ByVal Address As Integer, ByVal Data As Byte, _
                  ByVal DataNum As Integer) As Integer

Declare Function CM100_ReceiveCmd Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, Data As Byte, DataNum As Integer) As Integer
Declare Function CM100_SendCmd Lib "cm100.dll" _
                 (ByVal BoardNo As Byte, ByVal Port As Byte, Data As Byte, ByVal DataNum As Integer) As Integer
Declare Function CM100_ClearReceiveCmd Lib "cm100.dll" (ByVal BoardNo As Byte, ByVal Port As Byte) As Integer

Declare Function CM100_InstallUserISR Lib "cm100.dll" Alias "CM100_InstallUserISRA" _
                 (ByVal BoardNo As Byte, ByVal UserISR As Long) As Long
'UserISR is the format of Sub UserISR (Byval BoardNo as Byte, Byval InttValue as Byte)
Declare Function CM100_RemoveUserISR Lib "cm100.dll" (ByVal BoardNo As Byte) As Integer

Declare Function CM100_ReadUserInttType Lib "cm100.dll" (ByVal BoardNo As Byte, InttType As Byte) As Integer
Declare Function CM100_RunUserProgram Lib "cm100.dll" (ByVal BoardNo As Byte, ByVal Port As Byte) As Integer
Declare Function CM100_EndUserProgram Lib "cm100.dll" (ByVal BoardNo As Byte, ByVal Port As Byte) As Integer

