
#ifndef EXPORTS
#ifdef __cplusplus
     #define EXPORTS extern "C" __declspec (dllimport)
#else
     #define EXPORTS __declspec(dllimport)
#endif
#endif

#ifndef __PISO_CM100_HEADER__
#define __PISO_CM100_HEADER__

// return code
#ifndef DWORD
#define DWORD unsigned long
#endif

#ifndef WORD
#define WORD unsigned short
#endif

#ifndef BYTE
#define BYTE unsigned char
#endif

//====================
//Error Code Definitions
#define CM100_NoError                    0
#define CM100_DriverError                1
#define CM100_ActiveBoardError           2
#define CM100_BoardNumberError           3
#define CM100_PortNumberError            4
#define CM100_InitError                  7

#define CM100_SoftBufferIsEmpty          21
#define CM100_SoftBufferIsFull           22
#define CM100_TimeOut                    23
#define CM100_SetCyclicMsgFailure        24
#define CM100_DpramOverRange             25
#define CM100_NoDpramCmd                 26
#define CM100_ModeError                  27
#define CM100_NoFileInside               30
#define CM100_DownloadFailure            31
#define CM100_EEPROMDamage               32
#define CM100_NotEnoughSpace             33
#define CM100_StillDownloading           34
#define CM100_BoardModeError             35
#define CM100_SetDateTimeFailure         36

typedef struct config
{
	BYTE AccCode[4];
	BYTE AccMask[4];
	BYTE BaudRate;
	BYTE BT0,BT1;
} ConfigStruct;

//BaudRate 0:user define 1=10K   2=20K   3=50K  4=125K  5=250K  6=500K 7=800K  8=1Mbps

typedef struct packet
{	
	LONGLONG MsgTimeStamps;
	BYTE  mode;
	DWORD id;
	BYTE  rtr;
	BYTE  len;
	BYTE  data[8];
} PacketStruct;

//mode 0 -> 11 bits ID    1 -> 29 bits ID 

EXPORTS WORD CALLBACK CM100_GetDllVersion(void);
EXPORTS int CALLBACK CM100_GetBoardInf(BYTE BoardNo, DWORD *dwVID,DWORD *dwDID,
									   DWORD *dwSVID,DWORD *dwSDID,DWORD *dwSAuxID,
									   DWORD *dwIrqNo);
EXPORTS int CALLBACK CM100_TotalBoard(void);
EXPORTS int CALLBACK CM100_TotalCM100Board(void);
EXPORTS int CALLBACK CM100_TotalDNM100Board(void);
EXPORTS int CALLBACK CM100_TotalCPM100Board(void);
EXPORTS int CALLBACK CM100_GetCM100BoardSwitchNo(BYTE BoardCntNo, BYTE *BoardSwitchNo);
EXPORTS int CALLBACK CM100_GetDNM100BoardSwitchNo(BYTE BoardCntNo, BYTE *BoardSwitchNo);
EXPORTS int CALLBACK CM100_GetCPM100BoardSwitchNo(BYTE BoardCntNo, BYTE *BoardSwitchNo);
EXPORTS int CALLBACK CM100_GetCardPortNum(BYTE BoardNo, BYTE *bGetPortNum);

EXPORTS int CALLBACK CM100_ActiveBoard(BYTE BoardNo);
EXPORTS int CALLBACK CM100_CloseBoard(BYTE BoardNo);
EXPORTS int CALLBACK CM100_BoardIsActive(BYTE BoardNo);

EXPORTS int CALLBACK CM100_AdjustDateTime(BYTE BoardNo);

EXPORTS int CALLBACK CM100_Reset(BYTE BoardNo,BYTE Port);
EXPORTS int CALLBACK CM100_Init(BYTE BoardNo,BYTE Port);
EXPORTS int CALLBACK CM100_HardwareReset(BYTE BoardNo, BYTE Port);
EXPORTS int CALLBACK CM100_Check186Mode(BYTE BoardNo, BYTE *Mode);
EXPORTS int CALLBACK CM100_Status(BYTE BoardNo, BYTE Port,BYTE *bStatus);

EXPORTS int CALLBACK CM100_AddCyclicTxMsg(BYTE BoardNo, BYTE Port, BYTE Mode, DWORD MsgID,  
								  BYTE RTR, BYTE DataLen, BYTE *Data, DWORD TimePeriod, 
								  DWORD TransmitTimes, BYTE *Handle);

EXPORTS int CALLBACK CM100_DeleteCyclicTxMsg(BYTE BoardNo, BYTE Port,BYTE Handle);
EXPORTS int CALLBACK CM100_EnableCyclicTxMsg(BYTE BoardNo, BYTE Port,BYTE Handle);
EXPORTS int CALLBACK CM100_DisableCyclicTxMsg(BYTE BoardNo, BYTE Port,BYTE Handle);
EXPORTS int CALLBACK CM100_CheckCyclicTxRestMsg(BYTE BoardNo, BYTE Port, BYTE Handle, DWORD * RestCount);

EXPORTS int CALLBACK CM100_OutputByte(BYTE BoardNo, BYTE Port, WORD wOffset,BYTE bValue);
EXPORTS int CALLBACK CM100_InputByte(BYTE BoardNo, BYTE Port, WORD wOffset, BYTE *bValue);

EXPORTS int CALLBACK CM100_IsTxTimeout(BYTE BoardNo, BYTE Port, BYTE* Status);
EXPORTS int CALLBACK CM100_SetSystemMsg(BYTE BoardNo, BYTE Port, BYTE Mode);
////////////////////////////////////////////////////////////////
//                                                            //
//  Parameters and Functions Only For CM100 default Firmware  //
//                                                            //
////////////////////////////////////////////////////////////////
EXPORTS int CALLBACK CM100_ClearSoftBuffer(BYTE BoardNo, BYTE Port);
EXPORTS int CALLBACK CM100_ClearBufferStatus(BYTE BoardNo, BYTE Port);
EXPORTS int CALLBACK CM100_ClearTxSoftBuffer(BYTE BoardNo, BYTE Port);
EXPORTS int CALLBACK CM100_ClearRxSoftBuffer(BYTE BoardNo, BYTE Port);
EXPORTS int CALLBACK CM100_ClearDataOverrun(BYTE BoardNo, BYTE Port);
EXPORTS int CALLBACK CM100_Config(BYTE BoardNo, BYTE Port, ConfigStruct *CanConfig);
EXPORTS int CALLBACK CM100_ConfigWithoutStruct(BYTE BoardNo, BYTE Port, DWORD AccCode, DWORD AccMask, BYTE BaudRate, BYTE BT0, BYTE BT1);
EXPORTS int CALLBACK CM100_RxMsgCount(BYTE BoardNo, BYTE Port);
EXPORTS int CALLBACK CM100_ReceiveMsg(BYTE BoardNo, BYTE Port, PacketStruct *CanPacket);
EXPORTS DWORD CALLBACK CM100_ReceiveMultiMsg(BYTE BoardNo, BYTE Port, DWORD Cnt, WORD Timeout, PacketStruct *CanPacket);
EXPORTS int CALLBACK CM100_ReceiveWithoutStruct(BYTE BoardNo, BYTE Port, BYTE *Mode, DWORD *MsgID,
										        BYTE *RTR, BYTE *DataLen, BYTE *Data,
										        DWORD *UpperTime, DWORD *LowerTime);
EXPORTS DWORD CALLBACK CM100_ReceiveMultiMsgWithoutStruct(BYTE BoardNo, BYTE Port, DWORD Cnt, WORD Timeout, 
										BYTE *Mode, DWORD *MsgID, BYTE *Rtr, BYTE *Dlen, BYTE *Data,
										DWORD *UpperTime , DWORD *LowerTime);
EXPORTS int CALLBACK CM100_SendMsg(BYTE BoardNo, BYTE Port, PacketStruct *CanPacket);
EXPORTS int CALLBACK CM100_SendWithoutStruct(BYTE BoardNo, BYTE Port, BYTE Mode, DWORD MsgID, 
											 BYTE RTR, BYTE DataLen, BYTE *Data);
///////////////////////////////////////////////////////////////
//                                                           //
//  Parameters and Functions Only For user-defined Firmware  //
//                                                           //
///////////////////////////////////////////////////////////////

//Interrupt To User ISR
#define CAN_COMM_CMD_FROM_CM100  0xd1

//API Definitions
EXPORTS int CALLBACK CM100_SJA1000Config(BYTE BoardNo, BYTE Port, DWORD AccCode, DWORD AccMask, BYTE BaudRate, BYTE BT0, BYTE BT1);
EXPORTS int CALLBACK CM100_EnableSJA1000(BYTE BoardNo, BYTE Port);
EXPORTS int CALLBACK CM100_DisableSJA1000(BYTE BoardNo, BYTE Port);
EXPORTS int CALLBACK CM100_DPRAMInttToCM100(BYTE BoardNo, BYTE Port,BYTE Data);
EXPORTS int CALLBACK CM100_DPRAMWriteByte(BYTE BoardNo, BYTE Port, WORD Address, BYTE Data);
EXPORTS int CALLBACK CM100_DPRAMWriteWord(BYTE BoardNo, BYTE Port, WORD Address, WORD Data);
EXPORTS int CALLBACK CM100_DPRAMWriteDword(BYTE BoardNo, BYTE Port, WORD Address, DWORD Data);
EXPORTS int CALLBACK CM100_DPRAMWriteMultiByte(BYTE BoardNo, BYTE Port, WORD Address, BYTE *Data, WORD DataNum);
EXPORTS int CALLBACK CM100_DPRAMReadByte(BYTE BoardNo, BYTE Port, WORD Address, BYTE *Data);
EXPORTS int CALLBACK CM100_DPRAMReadWord(BYTE BoardNo, BYTE Port, WORD Address, WORD *Data);
EXPORTS int CALLBACK CM100_DPRAMReadDword(BYTE BoardNo, BYTE Port, WORD Address, DWORD *Data);
EXPORTS int CALLBACK CM100_DPRAMReadMultiByte(BYTE BoardNo, BYTE Port, WORD Address, BYTE *Data, WORD DataNum);
EXPORTS int CALLBACK CM100_DPRAMMemset(BYTE BoardNo, BYTE Port, WORD Address, BYTE Data, WORD DataNum);
EXPORTS int CALLBACK CM100_ReceiveCmd(BYTE BoardNo, BYTE Port, BYTE *Data, WORD *DataNum);
EXPORTS int CALLBACK CM100_SendCmd(BYTE BoardNo, BYTE Port, BYTE *Data, WORD DataNum);
EXPORTS int CALLBACK CM100_ClearReceiveCmd(BYTE BoardNo, BYTE Port);
//EXPORTS int CALLBACK CM100_InstallUserISR(BYTE BoardNo, void (*UserISR)(BYTE BoardNo_ISR, BYTE InttValue));
EXPORTS int CALLBACK CM100_InstallUserISR(BYTE BoardNo, void (CALLBACK * UserISR)(void));
EXPORTS int CALLBACK CM100_RemoveUserISR(BYTE BoardNo);
EXPORTS int CALLBACK CM100_ReadUserInttType(BYTE BoardNo, BYTE *InttType);
EXPORTS int CALLBACK CM100_RunUserProgram(BYTE BoardNo, BYTE Port);
EXPORTS int CALLBACK CM100_EndUserProgram(BYTE BoardNo, BYTE Port);
#endif // end define __PISO_CM100_HEADER__

