Attribute VB_Name = "CPM100U"
Option Explicit
'--------------------------------------------------
' CANopen Master Error Code Define
'--------------------------------------------------
Public Const CPM_NoError = 0
Public Const CPM_DriverError = 1

Public Const CPM_BoardNumberErr = 3

Public Const CPM_ConfigErr = 5
Public Const CPM_MasterInitErr = 6
Public Const CPM_MasterNotInit = 7
Public Const CPM_ListenMode = 8
Public Const CPM_NodeErr = 9
Public Const CPM_NodeExist = 10
Public Const CPM_AddModeErr = 11
Public Const CPM_TxBusy = 12
Public Const CPM_UnknowCmd = 13
Public Const CPM_CmdReceErr = 14
Public Const CPM_DataEmpty = 15
Public Const CPM_MemAllocErr = 16
Public Const CPM_SendCycMsgErr = 17
Public Const CPM_StatusErr = 18

Public Const CPM_SetGuardErr = 20
Public Const CPM_SetHbeatErr = 21
Public Const CPM_SegLenErr = 22
Public Const CPM_SegToggleErr = 23
Public Const CPM_SegWriteErr = 24
Public Const CPM_Abort = 25
Public Const CPM_PDOLenErr = 26
Public Const CPM_COBIDErr = 27
Public Const CPM_PDOInstErr = 28
Public Const CPM_PDODynaErr = 29
Public Const CPM_PDONumErr = 30
Public Const CPM_PDOSetErr = 31
Public Const CPM_PDOEntryErr = 32
Public Const CPM_SetCobIdErr = 33
Public Const CPM_CycFullErr = 34
Public Const CPM_Timeout = 35
Public Const CPM_DataLenErr = 36
Public Const CPM_SyncIdDifferent = 37

Public Const CPM_Wait = 40
Public Const CPM_Processing = 41

Public Const CPM_LoadEDSErr = 50
Public Const CPM_EDSFormatErr = 51

'--------------------------------------------------
' CANopen Master NMTErr Event Define
'--------------------------------------------------
Public Const CPM_Node_Guarding_Event = 1
Public Const CPM_Heartbeat_Event = 2

'--------------------------------------------------
' SYNC Group Send Stop State
'--------------------------------------------------
Public Const CPM_SYNC_GROUP_COMPLETE = 1
Public Const CPM_SYNC_GROUP_FAIL = 2

'--------------------------------------------------
' Common functions
'--------------------------------------------------
'////////////////////////////////////////
'//  PISO-CPM100U function library
'////////////////////////////////////////

'////////////////////////////////////////
'// Function: CPM100_GetVersion
'// Description: Return PISO-CM100(U).dll version
'// Parameter: void
'////////////////////////////////////////
Declare Function CPM100_GetVersion Lib "CPM100u.dll" () As Integer

'////////////////////////////////////////
'// Function: CPM100_TotalBoard
'// Description: Get total PISO-CPM100(U) board number
'// Parameter: void
'////////////////////////////////////////
Declare Function CPM100_TotalBoard Lib "CPM100u.dll" () As Integer

'////////////////////////////////////////
'// Function: CPM100_GetBoardSwitchNo
'// Description: Get PISO-CPM100(U) switch number
'// Parameter: bBoardCntNo: PISO-CPM100(U) board queue number
'//            *BoardNo: Board switch No of the PISO-CPM100(U) Board
'////////////////////////////////////////
Declare Function CPM100_GetBoardSwitchNo Lib "CPM100u.dll" _
    (ByVal bBoardCntNo As Byte, BoardNo As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_GetBoardInf
'// Description: Get PISO-CPM100(U) board information
'// Parameter: BoardNo: PISO-CPM100(U) board number
'//            *dwVID: Vendor ID
'//            *dwDID: Device ID
'//            *dwSVID: Sub-vendor ID
'//            *dwSDID: Sub-device ID
'//            *dwSAuxID: Sub-auxiliary ID
'//            *dwIrqNo: IRQ number
'////////////////////////////////////////
Declare Function CPM100_GetBoardInf Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, dwVID As Long, dwDID As Long, dwSVID As Long, _
                            dwSDID As Long, dwSAuxID As Long, dwIrqNo As Long) As Integer


'////////////////////////////////////////
'// Function: CPM100_GetCANStatus
'// Description: Get CAN error status of the PISO-CPM100(U) board
'// Parameter: BoardNo: PISO-CPM100(U) board number
'//            *bStatus: get CAN error status
'////////////////////////////////////////
Declare Function CPM100_GetCANStatus Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, bStatus As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_SetFunctionTimeout
'// Description: Set function timeout
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            FunTimeout: Max timeout ms of per function (default value = 1000 ms).
'////////////////////////////////////////
Declare Sub CPM100_SetFunctionTimeout Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal FunTimeout As Long)

'///////////////////////////////////////
'// Function: CPM100_InitMaster
'// Description: Initial Master, must be call once before all others function
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: 0 is for normal Master, 1 ~ 127 are for Master of slave-mode.
'//                  The slave-mode Master has node id and can be controled by other CANopen device.
'//                  We have provided some ISR function for user to do this.
'//            BaudRate: 0 ~ 7 ==> 10 k ~ 1000 k bps
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_InitMaster Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, _
    ByVal BaudRate As Byte, ByVal BlockMode As Byte) As Integer
                                        
'////////////////////////////////////////
'// Function: CPM100_ShutdownMaster
'// Description: Let PISO-CM100(U) shutdown (reset)
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'////////////////////////////////////////
Declare Function CPM100_ShutdownMaster Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte) As Integer
    
'////////////////////////////////////////
'// Driver Version: 2.02
'// Firmware Version: 2.02
'// Function: CPM100_MasterSendBootupMsg
'// Description: Let PISO-CPM100(U) send a boot up message (only for Master Node >= 1)
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'////////////////////////////////////////
Declare Function CPM100_MasterSendBootupMsg Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal BlockMode As Byte) As Integer
    
'////////////////////////////////////////
'// Function: CPM100_SetMasterMode
'// Description: Set Master to normal mode or listen mode
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Mode: 0 is normal mode (default), 1 is listen mode (default)
'//                  If set the Master to listen mode, the Master will can't send any CANopen message
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_SetMasterMode Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Mode As Byte, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_GetMasterMode
'// Description: Get Master mode
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            *Mode: 0 is normal mode (default), 1 is listen mode
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_GetMasterMode Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, Mode As Byte, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_GetFirmwareVersion
'// Description: Get PISO-CM100(U) firmware version
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            *Fir_Ver: PISO-CM100(U) firmware version
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_GetFirmwareVersion Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, Fir_Ver As Integer, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_EDS_Load
'// Description: Load EDS File
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node
'//            *FilePath: EDS file path (ex: "\\Temp\\ABC.EDS")
'//            DelayTime: After send a CAN message will delay some time
'//            ResTimeout: Set CAN message timeout
'////////////////////////////////////////
Declare Function CPM100_EDS_Load Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, FilePath As Byte, _
    ByVal DelayTime As Integer, ByVal ResTimeout As Integer, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_AddNode
'// Description: Add Slave Node to Master
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node
'//            AddMode: 1:Auto Add Node, 2:Add Manual, 3:Wait to Add
'//            DelayTime: After send a CAN message will delay some time
'//            ResTimeout: Set CAN message timeout
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_AddNode Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, ByVal AddMode As Byte, _
    ByVal DelayTime As Integer, ByVal ResTimeout As Integer, ByVal BlockMode As Byte) As Integer
    
'////////////////////////////////////////
'// Function: CPM100_RemoveNode
'// Description: Remove Slave Node from Master
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node Id
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_RemoveNode Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Driver Version: 2.02
'// Firmware Version: 2.02
'// Function: CPM100_RemoveAndResetNode
'// Description: Remove Slave and then Reset Node from Master
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_RemoveAndResetNode Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Driver Version: 2.03
'// Firmware Version: 2.02
'// Function: CPM100_DelayAndResponseTimeout
'// Description: Change delay time and response timeout value of the node
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node Id
'//            DelayTime: After send a CAN message will delay some time
'//            ResTimeout: Set CAN message timeout
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_DelayAndResponseTimeout Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, ByVal DelayTime As Integer, _
     ByVal ResTimeout As Integer, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_ScanNode
'// Description: Scan real node id on the CANopen bus
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            S_Node: Start scan node id
'//            E_Node: End scan node id
'//                    If S_Node > E_Node or E_Node = 0, will scan all node id (1~127)
'//            *NodeList: 16 BYTE Array. Return Node Id List of the CANopen Bus. Each bit represents a slave node
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_ScanNode Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal S_Node As Byte, ByVal E_Node As Byte, _
    NodeList As Byte, ByVal BlockMode As Byte) As Integer
    
'////////////////////////////////////////
'// Function: CPM100_GetNodeList
'// Description: Get Node Id List of the Master had added
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            *NodeList: 16 BYTE Array. Return Node Id List of the Master had added. Each bit represents a slave node
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_GetNodeList Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, NodeList As Byte, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_NMTChangeState
'// Description: Set Node State
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node Id
'//            State: NMT State
'//                  (1:Operation mode, 2:Stop mode, 128:Pre-operation mode, 129:Reset node, 130:Reset communication)
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_NMTChangeState Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, ByVal State As Byte, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_NMTGetState
'// Description: Get Node State
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node Id
'//            *State: Return NMT State
'//                   (4:Stop mode, 5:Operation mode, 127:Pre-operation mode)
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_NMTGetState Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, State As Byte, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_NMTGuarding
'// Description: Start Guarding
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node Id
'//            GuardTime: set index 0x100C
'//                      (Master will send Guarding message per GuardTime ms).
'//            LiftTime: set index 0x100D
'//                      (If Master doesn't receive Guarding response over LiftTime times, it will timeout and Node_Guarding_Event occur)
'//                      (The Guarding timeout = GuardTime * LiftTime )
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'// Note 1: It is not allowed for one slave to use both Guarding protocol and Heartbeat protocol at the same time.
'// Node 2: In listen mode, the function will listen the Guarding message send from other Master to slave on the CANopen bus.
'////////////////////////////////////////
Declare Function CPM100_NMTGuarding Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, _
    ByVal GuardTime As Integer, ByVal LiftTime As Byte, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_NMTHeartbeat
'// Description: Start Heartbeat
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node Id
'//            ProduceTime: set index 0x1017
'//            ConsumeTime: Timeout of Heartbeat
'//                         (ConsumeTime must more then ProduceTime)
'//                         (If Master doesn't receive slave Heartbeat over ConsumeTime ms, it will timeout and Heartbeat_Event occur)
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'// Note: It is not allowed for one slave to use both Guarding protocol and Heartbeat protocol at the same time.
'// Node 2: In listen mode, the function will listen only and can't start Heartbeat protocol. So Heartbeat protocol must start from other Master.
'////////////////////////////////////////
Declare Function CPM100_NMTHeartbeat Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, _
    ByVal ProduceTime As Integer, ByVal ConsumeTime As Integer, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_SDOReadData
'// Description: SDO Read Data. If the data length is more than 1024 bytes, the Data will return NULL,
'//              and user need uses CPM100_SDOReadFile to read the SDO data.
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node Id
'//            Index: Index of Object Dectionary
'//            SubIndex: SubIndex of Object Dectionary
'//            *RDLen: Response Data Length
'//            *RData: Response Data (If RDLen >= 1024, this parameter will return NULL.)
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_SDOReadData Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, _
    ByVal Index As Integer, ByVal SubIndex As Byte, _
    RDLen As Long, RData As Byte, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_SDOReadFile
'// Description: SDO Read File. After CPM100_SDOReadData, if the data length is more than 1024 bytes,
'//              user need uses this function to read the SDO data file.
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node
'//            *Index: Index of Object Dectionary
'//            *SubIndex: SubIndex of Object Dectionary
'//            Start: Start position to read the SDO data file
'//            Len: Max read byte
'//            RDLen: Return read data length
'//            RData: Return data
'////////////////////////////////////////
Declare Function CPM100_SDOReadFile Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, _
    ByVal Index As Integer, ByVal SubIndex As Byte, _
    ByVal Start As Long, ByVal DLen As Long, _
    RDLen As Long, RData As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_SDOWriteData
'// Description: SDO Write Data
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node Id
'//            Index: Index of Object Dectionary
'//            SubIndex: SubIndex of Object Dectionary
'//            TDLen: Write Data Length
'//            *TData: Write Data
'//            *RDLen: Response Data Length
'//            *RData: Response Data
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_SDOWriteData Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, _
    ByVal Index As Integer, ByVal SubIndex As Byte, _
    ByVal TDLen As Long, TData As Byte, _
    RDLen As Long, RData As Byte, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_SDOAbortTransmit
'// Description: Send SDO Abort Message
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node Id
'//            Index: Index of Object Dectionary
'//            SubIndex: SubIndex of Object Dectionary
'//            TData:  Abort Data
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_SDOAbortTransmit Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, _
    ByVal Index As Integer, ByVal SubIndex As Byte, _
    ByVal TData As Long, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_PDOWrite
'// Description: Output PDO data
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Cobid: PDO Cob Id
'//            Offset: Start Output byte
'//            DLen: Data Length
'//            *Data: PDO Data
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_PDOWrite Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal CobId As Integer, _
    ByVal Offset As Byte, ByVal DLen As Byte, Data As Byte, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Driver Version: 2.02
'// Firmware Version: 2.02
'// Function: CPM100_PDOWrite_Fast
'// Description: Output PDO data directly
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Cobid: PDO Cob Id
'//            DLen: Data Length
'//            Data: PDO Data
'////////////////////////////////////////
Declare Function CPM100_PDOWrite_Fast Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal CobId As Integer, ByVal Offset As Byte, _
     ByVal DLen As Byte, Data As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_PDORemote
'// Description: Remote PDO data
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Cobid: PDO Cob Id
'//            *DLen: Response Data Length
'//            *Data: Response PDO Data
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_PDORemote Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal CobId As Integer, _
    DLen As Byte, Data As Byte, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Driver Version: 2.02
'// Firmware Version: 2.02
'// Function: CPM100_PDORemote_Fast
'// Description: Send requst to remote PDO data, but do not check the response
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Cobid: PDO Cob Id
'////////////////////////////////////////
Declare Function CPM100_PDORemote_Fast Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal CobId As Integer) As Integer

'////////////////////////////////////////
'// Function: CPM100_SetPDORemotePolling
'// Description: Set PDO polling list for remote PDO (max 125 PDO one time)
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            PDOCnt: Total PDO number that want to be polling
'//            Cobid: PDO list that want to be polling
'//            PollingTime: Min. polling Time
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_SetPDORemotePolling Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal PDOCnt As Byte, _
    CobId As Integer, ByVal PollingTime As Integer, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_GetPDOLastData
'// Description: Get PDO last data
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Cobid: PDO Cob Id
'//            *IsNew: Is new data, 0 is old data, 1 is new data
'//            *DLen: Get PDO Data Length
'//            *Data: Get PDO Data
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_GetPDOLastData Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal CobId As Integer, _
    IsNew As Byte, DLen As Byte, Data As Byte, ByVal BlockMode As Byte) As Integer
    
'////////////////////////////////////////
'// Driver Version: 2.02
'// Firmware Version: 2.02
'// Function: CPM100_GetPDOLastData_Fast
'// Description: Get PDO data from DPRAM directly
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Cobid: PDO Cob Id
'//            *DLen: PDO Data Length
'//            *Data: PDO Data
'////////////////////////////////////////
Declare Function CPM100_GetPDOLastData_Fast Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal CobId As Integer, DLen As Byte, Data As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_GetMultiPDOData
'// Description: Get multi PDO data (this function can get max 50 PDO data every times)
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            PDOCnt: Total PDO number that want to get
'//            Cobid: All PDO Cob Id that want to get
'//            IsNew: Is new data, 0 is old data, 1 is new data (array size = PDOCnt)
'//            DLen: PDO Data Length (array size = PDOCnt)
'//            Data: PDO Data (array size = PDOCnt * 8)
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_GetMultiPDOData Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal PDOCnt As Byte, CobId As Integer, _
    IsNew As Byte, DLen As Byte, Data As Byte, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Driver Version: 2.02
'// Firmware Version: 2.02
'// Function: CPM100_GetMultiPDOData_Fast
'// Description: Get multi PDO data from DPRAM directly
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            PDOCnt: Total PDO number that want to get
'//            Cobid: All PDO Cob Id that want to get
'//            DLen: PDO Data Length
'//            Data: PDO Data
'////////////////////////////////////////
Declare Function CPM100_GetMultiPDOData_Fast Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal PDOCnt As Byte, CobId As Integer, _
     DLen As Byte, Data As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_GetRxPDOID
'// Description: Get Rx PDO Cob ID List of slave
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node Id
'//            *PDO_Cnt: Response RxPDO ID total number
'//            *Id_List: Response *PDO_Cnt number RxPDO ID List
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_GetRxPDOID Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, _
    PDO_Cnt As Byte, Id_List As Integer, ByVal BlockMode As Byte) As Integer
    
'////////////////////////////////////////
'// Function: CPM100_GetTxPDOID
'// Description: Get Tx PDO Cob ID List of slave
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node Id
'//            *PDO_Cnt: Response TxPDO ID total number
'//            *Id_List: Response *PDO_Cnt number TxPDO ID List
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_GetTxPDOID Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, _
    PDO_Cnt As Byte, Id_List As Integer, ByVal BlockMode As Byte) As Integer
    
'////////////////////////////////////////
'// Function: CPM100_InstallPDO
'// Description: Install PDO ID to Master
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node Id
'//            Cobid: PDO Cob ID
'//            RxTx: 0 is RxPDO, 1 is TxPDO
'//            PDO_No: PDO No. 0 ~ 511
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_InstallPDO Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, ByVal CobId As Integer, _
    ByVal RxTx As Byte, ByVal PDO_No As Integer, ByVal BlockMode As Byte) As Integer
    
'////////////////////////////////////////
'// Function: CPM100_DynamicPDO
'// Description: Dynamic PDO Mapping to Master
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node Id
'//            Cobid: PDO Cob ID
'//            RxTx: 0 is RxPDO, 1 is TxPDO
'//            Entry: Mapping Entry
'//            EntryData: Mapping Data
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_DynamicPDO Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, ByVal CobId As Integer, _
    ByVal RxTx As Byte, ByVal Entry As Integer, ByVal EntryData As Long, _
    ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_RemovePDO
'// Description: Remove POD Entry
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node Id
'//            Cobid: PDO Cob ID
'//            Entry: Remove Entry, 0 is for whole PDO
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_RemovePDO Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, ByVal CobId As Integer, _
    ByVal Entry As Integer, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_ChangePDOID
'// Description: Change POD ID
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Old_Cobid: Old Cobid
'//            New_Cobid: Want to change to New Cobid
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_ChangePDOID Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Old_Cobid As Integer, ByVal New_Cobid As Integer, _
    ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_GetPDOMapInfo
'// Description: Get PDO mapping information
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Cobid: PDO Cobid
'//            *PDONo: Get PDO No.
'//            *RxTx: 0 is RxPDO, 1 is TxPDO
'//            *Tx_Type: Transmission Type
'//            *Event_Timer: Event Timer
'//            *Entry_Cnt: Total entry number
'//            *Map_Data: Mapping Data (max size array =  8)
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_GetPDOMapInfo Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal CobId As Integer, _
    PDONo As Integer, RxTx As Byte, Tx_Type As Byte, Event_Timer As Integer, _
    Entry_Cnt As Byte, Map_Data As Long, ByVal BlockMode As Byte) As Integer
    
'////////////////////////////////////////
'// Function: CPM100_InstallPDO_List (Virtual List)
'// Description: Install PDO and Mapping PDO Data to Master List.
'//              This function like CPM100_InstallPDO_List, but it only build a virtual PDO let Master
'//              can control the PDO. The virtual PDO is not the real node slave necessarily.
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node Id
'//            Cobid: PDO Cob ID
'//            RxTx: 0 is RxPDO, 1 is TxPDO
'//            PDO_No: PDO No.
'//            TransmitType: Set transmission type
'//            EventTimer: Set event timer
'//            EntryUse: Total Mapping Entry
'//            *EntryData: DWORD array for Total Mapping Data
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_InstallPDO_List Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, ByVal CobId As Integer, _
    ByVal RxTx As Byte, ByVal PDO_No As Integer, ByVal TransmitType As Byte, _
    ByVal EventTimer As Integer, ByVal EntryUse As Byte, EntryData As Long, _
    ByVal BlockMode As Byte) As Integer
    
'////////////////////////////////////////
'// Function: CPM100_RemovePDO_List (Virtual List)
'// Description: Remove PDO build from CPM100_InstallPDO_List function
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node Id
'//            Cobid: PDO Cob ID
'//            Entry: Remove Entry, 0 is for whole PDO
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_RemovePDO_List Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, ByVal CobId As Integer, _
    ByVal Entry As Byte, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_PDOUseEntry
'// Description: Change useful entry
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Cobid: PDO Cob ID
'//            Entry: useful entry
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_PDOUseEntry Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal CobId As Integer, _
    ByVal Entry As Byte, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_PDOTxType
'// Description: Set PDO Transmission Type
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Cobid: PDO Cob ID
'//            Tx_Type: Transmission Type
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_PDOTxType Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal CobId As Integer, _
    ByVal Tx_Type As Byte, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_PDOEventTimer
'// Description: Set PDO Event Timer
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Cobid: PDO Cob ID
'//            Timer: Event Timer
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_PDOEventTimer Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal CobId As Integer, _
    ByVal Timer As Integer, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Driver Version: 2.03
'// Firmware Version: 2.02
'// Function: CPM100_PDOInhibitTime
'// Description: Set PDO Inhibit Time
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Cobid: PDO Cob ID
'//            Timer: Inhibit Time
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_PDOInhibitTime Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal CobId As Integer, ByVal Time As Integer, _
     ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_ChangeSYNCID
'// Description: Change SYNC ID
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node Id
'//            Cobid: SYNC ID
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_ChangeSYNCID Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, ByVal CobId As Integer, _
    ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_SetSYNC_List (Virtual List)
'// Description: Set or Change SYNC ID from Master
'//              The function only build a virtual SYNC ID let Master can control it.
'//              The virtual SYNC ID is not the real one necessarily.
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node Id
'//            Cobid: PDO Cob ID
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_SetSYNC_List Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, ByVal CobId As Integer, _
    ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_GetSYNCID
'// Description: Get SYNC ID
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node Id
'//            *Cobid: SYNC ID
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_GetSYNCID Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, CobId As Integer, _
    ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_SendSYNCMsg
'// Description: Send SYNC message, most send 5 different SYNC at the same time
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Cobid: SYNC ID
'//            Timer: Cyclic timer, 0 is stop or send 1 time SYNC message
'//            Times: Cyclic times, 0 is always contiune
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_SendSYNCMsg Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal CobId As Integer, _
    ByVal Timer As Integer, ByVal Times As Long, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM_SyncGroupCycUpdata
'// Driver Version: 2.05
'// Firmware Version: 2.03
'// Description: Before use CPM100_SyncGroupCycSend to send SYNC and PDO group data, users should
'//              use this function to fill the Max 15 cycle buffer. If uses want their devices run
'//              more group cycles, users can still use this function to contiunously fill the cycle
'//              buffer after execute CPM100_SyncGroupCycSend.
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            RecordNum: PDO number of this SYNC group. This parameter is < 10. (Every update, the PDO number of the group data must be the same.)
'//            CycNum: Cycle number of this update mission. This parameter is < 15.
'//            *PDOId: PDO ID Array of these group data (Array type: WORD [RecordNum])
'//            *GroupData: Initial Data of output every PDO (Array type: BYTE [StepNum][RecordNum][8])
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_SyncGroupCycUpdata Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal RecordNum As Byte, ByVal CycNum As Byte, _
    PDOId As Integer, GroupData As Byte, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM_SyncGroupCycSend
'// Driver Version: 2.05
'// Firmware Version: 2.03
'// Description: Use this function start to Send SYNC and PDO group data from group cycle buffer
'//              (Update by CPM_SyncGroupCycUpdata).
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            TotalCycle: Total Cycle for this Sync Group. TotalCycle = 0 means unlimited.
'//            CycInterval: Cycle timer, unit is 0.1 ms and minimum value is 5 (0.5 ms).
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_SyncGroupCycSend Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal TotalCycle As Long, ByVal CycInterval As Long, _
    ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM_SyncGroupClear
'// Driver Version: 2.05
'// Firmware Version: 2.03
'// Description: Clear All Step of the SYNC Group Send
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'// Return: CPM_NoError, CPM_Timeout
'////////////////////////////////////////
Declare Function CPM100_SyncGroupClear Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM_GetCyclicSYNCInfo
'// Description: Get Cyclic SYNC Info
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            *Cobid: 5 WORD Array, SYNC ID
'//            *Timer: 5 WORD Array, Cyclic timer, 0 is stop or 1 time and
'//            *Times: 5 DWORD Array, Cyclic times, 0 is always contiune
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_GetCyclicSYNCInfo Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, CobId As Integer, _
    Timer As Integer, Times As Long, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_ChangeEMCYID
'// Description: Change EMCY ID
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node Id
'//            Cobid: EMCY ID
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_ChangeEMCYID Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, ByVal CobId As Integer, _
    ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_SetEMCY_List (Virtual List)
'// Description: Set or Change EMCY ID from Master
'//              The function only build a virtual EMCY ID let Master can control it.
'//              The virtual EMCY ID is not the real one necessarily.
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node Id
'//            Cobid: PDO Cob ID
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_SetEMCY_List Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, ByVal CobId As Integer, _
    ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_GetEMCYID
'// Description: Get EMCY ID
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node
'//            *Cobid: EMCY ID
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_GetEMCYID Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, CobId As Integer, _
    ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_ReadLastEMCY
'// Description: Get last message of the slave node
'// Parameter: BoardNo: PISO-CPM100(U) board number.
'//            Node: Slave Node Id
'//            *IsNew: Is new data, 0 is old data, 1 is new data
'//            *Data: EMCY Data
'//            BlockMode: Function Mode: Non-block function mode = 0, Block function mode = 1
'////////////////////////////////////////
Declare Function CPM100_ReadLastEMCY Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal Node As Byte, _
    IsNew As Byte, Data As Byte, ByVal BlockMode As Byte) As Integer

'////////////////////////////////////////
'// Driver Version: 2.05
'// Firmware Version: 2.03
'// Function: CPM100_GetSYNCGroupStopState
'// Description: Get SYNC Group Send Stop State after SYNC Group Send Stop
'// Parameter: *BoardNo: PISO-CPM100(U) board number.
'//            *State: 1: SYNC Group Send Complete, 2: SYNC Group Send Fail
'////////////////////////////////////////
Declare Function CPM100_GetSYNCGroupStopState Lib "CPM100u.dll" _
    (BoardNo As Byte, State As Byte) As Integer

'////////////////////////////////////////
'// Driver Version: 2.02
'// Firmware Version: 2.02
'// Function: CPM100_GetBootUpNodeAfterAdd
'// Description: Get Boot up message after add node
'// Parameter: *BoardNo: PISO-CPM100(U) board number.
'//            *Node: Slave Node Id
'////////////////////////////////////////
Declare Function CPM100_GetBootUpNodeAfterAdd Lib "CPM100u.dll" _
    (BoardNo As Byte, Node As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_GetEMCYData
'// Description: Get EMCY data received from the PISO-CPM100(U)
'// Parameter: *BoardNo: PISO-CPM100(U) board number.
'//            *Node: Slave Node Id
'//            *Data: EMCY Data
'////////////////////////////////////////
Declare Function CPM100_GetEMCYData Lib "CPM100u.dll" _
    (BoardNo As Byte, Node As Byte, Data As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_GetNMTError
'// Description: Get NMT Error Control message from CANopen slave.
'// Parameter: *BoardNo: PISO-CPM100(U) board number.
'//            *Node: Slave Node Id
'//            *NMTErrMode: Get NMT Error mode.
'//                         If Node_Guarding_Event, Mode = CPM_Node_Guarding_Event.
'//                         And if Heartbeat_Event, Mode = CPM_Heartbeat_Event.
'////////////////////////////////////////
Declare Function CPM100_GetNMTError Lib "CPM100u.dll" _
    (BoardNo As Byte, Node As Byte, NMTErrMode As Byte) As Integer

'// CPM100_InstallSYNCGroupISR:
'// Driver Version: 2.05
'// Firmware Version: 2.03
'// After called CPM100_InstallSYNCGroupISR to install SYNC Group ISR function.
'// When the SYNC Group data is stopped, a stop state event will produce. And than
'// the SYNC Group ISR will be executed.
Declare Function CPM100_InstallSYNCGroupISR Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal SYNCISR As Long) As Integer
' SYNCISR format : Sub SYNCISR()
Declare Function CPM100_RemoveSYNCGroupISR Lib "CPM100u.dll" (ByVal BoardNo As Byte) As Integer

'// CPM100_InstallBootUpISR:
'// Driver Version: 2.02
'// Firmware Version: 2.02
'// After called CPM100_InstallBootUpISR to install Boot ISR function.
'// When the Master received a Boot up message send from other slave device witch
'// had been added to the Master by calling CPM100_AddNode, the Boot up ISR will be executed.
Declare Function CPM100_InstallBootUpISR Lib "CPM100u.dll" _
   (ByVal BoardNo As Byte, ByVal BOOTISR As Long) As Integer
' BOOTISR format : Sub BOOTISR()
Declare Function CPM100_RemoveBootUpISR Lib "CPM100u.dll" (ByVal BoardNo As Byte) As Integer

'// CPM100_InstallRxSDOISR:
'// After called CPM100_InstallEMCYISR to install EMCY ISR function.
'// When the Master received a EMCY message send from other slave device witch
'// had been added to the Master by calling CPM100_AddNode, the EMCY ISR will be executed.
Declare Function CPM100_InstallEMCYISR Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal EMCYISR As Long) As Integer
' EMCYISR format : Sub EMCYISR()
Declare Function CPM100_RemoveEMCYISR Lib "CPM100u.dll" (ByVal BoardNo As Byte) As Integer


'// CPM100_InstallNMTErrISR:
'// After called CPM100_InstallNMTErrISR to install NMTErr ISR function.
'// When the Master occured a Node_Guarding_Event or Heartbeat_Event, the NMTErr ISR will be executed.
Declare Function CPM100_InstallNMTErrISR Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal NMTERRISR As Long) As Integer
' NMTERRISR format : Sub NMTERRISR()
Declare Function CPM100_RemoveNMTErrISR Lib "CPM100u.dll" (ByVal BoardNo As Byte) As Integer


'///////////////////////////////////////////////////////////////////////////////////////////////////
'// Following ISR Funtions are only for Master with node id > 0.
'// It means if the "Node" parameter of CPM100_InitMaster is 0, the following functions will useless.
'///////////////////////////////////////////////////////////////////////////////////////////////////

'////////////////////////////////////////
'// Function: CPM100_GetMasterReadSDOEvent
'// Description: Get the Read SDO message for Master node id.
'// Parameter: *BoardNo: PISO-CPM100(U) board number.
'//            *Index: Index of Object Dectionary.
'//            *SubIndex: SubIndex of Object Dectionary.
'////////////////////////////////////////
Declare Function CPM100_GetMasterReadSDOEvent Lib "CPM100u.dll" _
    (BoardNo As Byte, Index As Integer, SubIndex As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_GetMasterWriteSDOEvent
'// Description: Get the Write SDO message for Master node id.
'// Parameter: *BoardNo: PISO-CPM100(U) board number.
'//            *Index: Index of Object Dectionary.
'//            *SubIndex: SubIndex of Object Dectionary.
'//            *WLen: Write Data Length.
'//            *WData: Write Data.
'////////////////////////////////////////
Declare Function CPM100_GetMasterWriteSDOEvent Lib "CPM100u.dll" _
    (BoardNo As Byte, Index As Integer, SubIndex As Byte, WLen As Byte, WData As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_ResponseMasterSDO
'// Description: Response SDO message from CPM100U
'// Parameter: ResType: Response read/write to SDO message (0 is read response, 1 is write response)
'//            Index: Response Index of Object Dectionary
'//            SubIndex: Response SubIndex of Object Dectionary
'//            Len: Response data length (0 ~ 4) (Note: Write response must 0-byte)
'//            *Data: Response data array (max. 4-bytes)
'////////////////////////////////////////
Declare Function CPM100_ResponseMasterSDO Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal ResType As Byte, _
    ByVal Index As Integer, ByVal SubIndex As Byte, ByVal ResLen As Byte, Data As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_GetMasterRemotePDOEvent
'// Description: Get the Remote PDO message for Master's PDO COB-ID.
'// Parameter: *BoardNo: PISO-CPM100(U) board number.
'//            *CobId: PDO Cob Id.
'////////////////////////////////////////
Declare Function CPM100_GetMasterRemotePDOEvent Lib "CPM100u.dll" _
    (BoardNo As Byte, CobId As Integer) As Integer

'////////////////////////////////////////
'// Function: CPM100_GetMasterRxPDOEvent
'// Description: Get the Write PDO message for Master's PDO COB-ID.
'// Parameter: *BoardNo: PISO-CPM100(U) board number.
'//            *CobId: PDO Cob Id.
'//            *WLen: Write Data Length.
'//            *WData: Write Data.
'////////////////////////////////////////
Declare Function CPM100_GetMasterRxPDOEvent Lib "CPM100u.dll" _
    (BoardNo As Byte, CobId As Integer, WLen As Byte, WData As Byte) As Integer

'////////////////////////////////////////
'// Function: CPM100_ResponseMasterPDO
'// Description: Response remote PDO message from CPM100U
'// Parameter: CobId: Response remote PDO Cob Id.
'//            Len: Response data length (1 ~ 8).
'//            *Data: Response data array (max. 8-bytes).
'////////////////////////////////////////
Declare Function CPM100_ResponseMasterPDO Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal CobId As Integer, ByVal ResLen As Byte, Data As Byte) As Integer

'// CPM100_InstallReadSDOISR:
'// If the Master had called CPM100_InitMaster to initial Master with node n (128 > n > 0).
'// After installed CPM100_InstallReadSDOISR, when the Master received a Read RxSDO message (message Cob ID is 0x600+n)
'// and the Master will produce an interrupt to execute the RSDOISR ISR function.
Declare Function CPM100_InstallReadSDOISR Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal RSDOISR As Long) As Integer
' RSDOISR format : Sub RSDOISR()
Declare Function CPM100_RemoveReadSDOISR Lib "CPM100u.dll" (ByVal BoardNo As Byte) As Integer


'// CPM100_InstallWriteSDOISR:
'// If the Master had called CPM100_InitMaster to initial Master with node n (128 > n > 0).
'// After installed CPM100_InstallWriteSDOISR, when the Master received a Write RxSDO message (message Cob ID is 0x600+n)
'// and the Master will produce an interrupt to execute the WSDOISR ISR function.
Declare Function CPM100_InstallWriteSDOISR Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal WSDOISR As Long) As Integer
' WSDOISR format : Sub WSDOISR()
Declare Function CPM100_RemoveWriteSDOISR Lib "CPM100u.dll" (ByVal BoardNo As Byte) As Integer


'// CPM100_InstallRxPDOISR:
'// If the Master had called CPM100_InitMaster to initial Master with node n (128 > n > 0).
'// And if the Master also had called CPM100_InstallPDO_List to install a RxPDO to itself (ex: PDO Cob ID is 0x200+n).
'// After installed CPM100_InstallRxPDOISR, when the Master received the RxPDO message
'// and the Master will produce an interrupt to execute the RXPDOISR ISR function.
Declare Function CPM100_InstallRxPDOISR Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal RXPDOISR As Long) As Integer
' RXPDOISR format : Sub RXPDOISR()
Declare Function CPM100_RemoveRxPDOISR Lib "CPM100u.dll" (ByVal BoardNo As Byte) As Integer


'// CPM100_InstallRemotePDOISR:
'// If the Master had called CPM100_InitMaster to initial Master with node n (128 > n > 0).
'// And if the Master also had called CPM100_InstallPDO_List to install a TxPDO to itself (ex: PDO Cob ID is 0x180+n).
'// After installed CPM100_InstallRemotePDOISR, when the Master received the TxPDO message
'// and the Master will produce an interrupt to execute the REMOTEPDOISR ISR function.
Declare Function CPM100_InstallRemotePDOISR Lib "CPM100u.dll" _
    (ByVal BoardNo As Byte, ByVal REMOTEPDOISR As Long) As Integer
' REMOTEPDOISR format : Sub REMOTEPDOISR()
Declare Function CPM100_RemoveRemotePDOISR Lib "CPM100u.dll" (ByVal BoardNo As Byte) As Integer



